Imports System.Runtime.Serialization
Imports System.Runtime.Serialization.Formatters.Binary
Imports System.IO

<Serializable()> _
    Public Class CustomCarType
    Implements ISerializable
    Public petName As String
    Public maxSpeed As Integer

    Public Sub New(ByVal s As String, ByVal i As Integer)
        petName = s
        maxSpeed = i
    End Sub

    ' Implmentaion de l'interface ISerializable.
    Public Sub GetObjectData(ByVal si As SerializationInfo, ByVal ctx As StreamingContext) Implements iserializable.GetObjectData
        ' De quel contexte est le flux ?
        Console.WriteLine("[GetObjectData] Etat du contexte: {0}", ctx.State.ToString())

        ' Remplire l'objet de type SerializationInfo avec les informations de sortie.
        si.AddValue("CapPetName", petName)
        si.AddValue("maxSpeed", maxSpeed)
    End Sub

    ' Vous devez fournir un constructeur personnalis avec cette signature
    ' pour permettre au moteur d'excution de dfinir
    ' l'tat de votre objet.
    Private Sub New(ByVal si As SerializationInfo, ByVal ctx As StreamingContext)

        ' Quel est le contexte du flux ?
        Console.WriteLine("[ctor] Etat du contexte: {0}", ctx.State.ToString())

        ' Remplir un nouvel objet bas sur les donnes
        ' entrantes du type SerializationInfo.
        petName = si.GetString("CapPetName")
        maxSpeed = si.GetInt32("maxSpeed")
    End Sub
End Class

Module Module1
    Sub Main()
        ' Construire une voiture et couter la radio.
        Console.WriteLine("Construction d'une voiture...")
        Dim myAuto As CustomCarType = New CustomCarType("Siddhartha", 50)

        ' Cration d'un flux de fichier.
        Console.WriteLine("Cration d'un fichier *.dat...")
        Dim myStream As Stream = File.Create("CarData.dat")

        ' L'interface ISerializable est obtenue!  
        Console.WriteLine("Sauvegarde vers un fichier.")
        Dim myBinaryFormat As BinaryFormatter = New BinaryFormatter()
        myBinaryFormat.Serialize(myStream, myAuto)
        myStream.Close()

        Console.WriteLine("Lecture depuis un fichier.")
        myStream = File.OpenRead("CarData.dat")

        Dim carFromDisk As CustomCarType = _
           CType(myBinaryFormat.Deserialize(myStream), CustomCarType)

        Console.WriteLine(carFromDisk.petName + " est en tat de marche!")
        myStream.Close()
    End Sub
End Module
